// Pixel shader input structure
struct PS_INPUT
{
    float4 Position   : POSITION;			// UNUSED
    float2 Texture0   : TEXCOORD0;
    float2 Texture1   : TEXCOORD1;
};

// Pixel shader output structure
struct PS_OUTPUT
{
    float4 Color   : COLOR0;
};

sampler2D Tex0 : register(s0);				// This is the contents of the screen from the last full draw frame
sampler2D Tex1 : register(s1);				// This is the result of the image produced from wave.psh

PS_OUTPUT main( in PS_INPUT In )
{ 
    PS_OUTPUT Out;
	
	float4 aHoleColor = tex2D(Tex0, In.Texture0);    
    float4 anOrigColor = tex2D(Tex1, In.Texture1);    
    
	Out.Color = float4(anOrigColor.r, anOrigColor.g, anOrigColor.b, aHoleColor.a) +
		float4(aHoleColor.r*aHoleColor.a, aHoleColor.g*aHoleColor.a, aHoleColor.b*aHoleColor.a, 0);

    return Out;
}

technique Default
<
	string rfx_fallback_technique = "Default_FB1";
>
{
	pass P0
	{
		PixelShader = compile ps_2_0 main();
	}
}

technique Default_FB1
<
	string rfx_fallback_technique = "Default_FB2";
>
{
	// requires that diffuse color is black (at least on RGB channels)
	pass P0
	{
		ColorOp[0] = BLENDTEXTUREALPHA; ColorArg1[0] = TEXTURE; ColorArg2[0] = DIFFUSE;
		AlphaOp[0] = SELECTARG1;        AlphaArg1[0] = TEXTURE; AlphaArg2[0] = DIFFUSE;
		ColorOp[1] = ADD;				ColorArg1[1] = TEXTURE; ColorArg2[1] = CURRENT;
		AlphaOp[1] = SELECTARG2;		AlphaArg1[1] = TEXTURE; AlphaArg2[1] = CURRENT;
	}
}

technique Default_FB2
{
	// handled in a special multi-pass manner in code
	pass P0
	{
		ColorOp[0] = MODULATE;          ColorArg1[0] = TEXTURE; ColorArg2[0] = DIFFUSE;
		AlphaOp[0] = MODULATE;          AlphaArg1[0] = TEXTURE; AlphaArg2[0] = DIFFUSE;
	}
}
